/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/DummyBasicQuery.java,v 1.3 2004/07/30 06:51:57 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;


import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.basic.BasicQueryImpl;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.jdom.Element;



/**
 * Implements a query that does nothing. May be used for stores, that shall be
 * excluded from SEARCH.
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class DummyBasicQuery extends BasicQueryImpl implements IBasicQuery {
    
    /**
	 * Constructor
	 */
	public DummyBasicQuery () {
    }
    
	/**
	 * Constructor
	 */
    public DummyBasicQuery (SearchToken searchToken) {
        super (searchToken);
    }
    
	/**
	 * Override BasicQueryImpl.parseQuery () to do nothing
	 *
	 * @param    basicSearchElement  an Element
	 * @param    propertyProvider    a  PropertyProvider
	 *
	 * @throws   BadQueryException
	 *
	 */
    public void parseQuery (Element basicSearchElement,
                            PropertyProvider propertyProvider)
        throws BadQueryException
    {
    }
    
	/**
	 * Method execute
	 *
	 * @return   a SearchQueryResult
	 *
	 * @throws   ServiceAccessException
	 *
	 */
    public SearchQueryResult execute() throws ServiceAccessException {
        return new SearchQueryResult ();
    }
    
	/**
	 * Method getExpressionFactory
	 *
	 * @return   an IBasicExpressionFactory
	 *
	 */
    public IBasicExpressionFactory getExpressionFactory() {
        return null;
    }
}


