/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/IContentQueryFilter.java,v 1.3 2004/07/30 06:51:57 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

/**
 * If the result set is known (the contentIds of all members), additional
 * queries (to get xPath properties) may get a filter with these ino:id's.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public interface IContentQueryFilter {

    /**
     * Creates an XPath filter for XPathProperties.
     *
     * @param    schema          a  String
     *
     * @return   an XPath filter
     *
     */
    String getXPathFilter (String schema);

    /**
     * returns true, if the result set has entries for this schema
     *
     * @param    schema              a  String
     *
     * @return   a boolean
     *
     */
    boolean hasResults (String schema);

}

