/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/IQueryExecuter.java,v 1.3 2004/07/30 06:51:57 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.IBasicResultSet;


/**
 * An IQueryExecuter can execute the queryString on the xdav metadata
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public interface IQueryExecuter {
    
    /**
     * Method execute
     *
     * @param    queryString         a  String defining the Tamino query
     *
     * @return   an IBasicResultSet
     *
     * @throws   SearchException
     *
     */
     IBasicResultSet execute (String queryString) throws SearchException;
}


