/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/LimitIterator.java,v 1.3 2004/07/30 06:51:57 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:57 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

/**
 * Iterator, that may limit the number of results returned by the
 * wrapped Iterator. If limit == 0, then the result is not limited.
 *
 */
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;

/**
 * Wraps a TXMLObjectIterator. If limit is set, stops after limit elements
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class LimitIterator {

    private int count;
    private int limit;
    private TXMLObjectIterator it;

    LimitIterator (TXMLObjectIterator it, int limit) {
        this.it = it;
        this.limit = limit;
    }

    /**
     * Method hasNext
     *
     * @return   a boolean
     *
     */
    public boolean hasNext() {
        boolean result;

        if (limit > 0) {
            if (count < limit)
                result = it.hasNext();
            else
                result = false;
        }
        else
            result = it.hasNext();

        return result;
    }

    /**
     * Method next
     *
     * @return   a TXMLObject
     *
     * @throws   TException
     *
     */
    public TXMLObject next() throws TException {
        count++;
        return it.next();
    }
}


