/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XCompareHint.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.common.PropertyName;
import org.apache.slide.search.CompareHint;

/**
 * A CompareHint, that additionally may return a sortall expression for
 * the query engine
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class XCompareHint extends CompareHint {


    private String sortBy;

    public XCompareHint (PropertyName prop,
                         boolean ascending,
                         boolean caseSensitive) {

        super (prop, ascending, caseSensitive);
        if (prop instanceof XComparedPropertyName) {

            this.sortBy = ((XComparedPropertyName)prop).getSortAllExpression();
        }
    }

    public String getSortBy () {
        return sortBy;
    }

   public String getPropName () {
        return propName;
    }

    /**
     * Method getPropNamespace
     *
     * @return   the property's namespace
     *
     */
    public String getPropNamespace () {
        return propNamespace;
    }

}

