/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XComparedPropertyName.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.common.PropertyName;
import org.apache.slide.search.InvalidQueryException;

/**
 * <p>Holds a (name and namespace) as well as a sortall expression, that helps
 * the query engine to find the first n results, if &lt;limit&gt; is used.</p>
 * <p> An XCompared property is created for XPath orderby expressions </p>
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class XComparedPropertyName extends PropertyName {
    private String sortAll;

    /**
     * Constructor
     *
     * @param    name                name of the compared property
     * @param    namespace           the namespace of the compared property
     * @param    contentQuery        the  XPathContentQuery that creates the XPath property
     *
     * @throws   InvalidQueryException
     *
     */
    XComparedPropertyName (String name, String namespace, XPathContentQuery contentQuery) throws InvalidQueryException {
        super (name, namespace);
        this.sortAll = contentQuery.getXPath().extractSortAll();
    }

    /**
     * Method getSortAllExpression
     *
     * @return   a String
     *
     */
    public String getSortAllExpression () {
        return sortAll;
    }
}

