/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XDescriptorsMapping.java,v 1.1 2004/03/25 16:18:01 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:01 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.util.XAssertionFailed;

/** (Descriptors, Uri+) **/
public class XDescriptorsMapping {
    private final String uuri;
    
    /** list of uri Strings without starting and without tailing slash */
    private final List mapping;
    
    public XDescriptorsMapping(String uuri) {
        this.uuri = uuri;
        this.mapping = new ArrayList();
    }
    
    public String getUuri() {
        return uuri;
    }
    
    public void add(String uri) {
        if (uri.startsWith("/")) {
            throw new XAssertionFailed(uri);
        }
        mapping.add(uri);
    }
    
    public String getQuery() {
        return "@uri=\"" + getUuri() + "\"";
    }
    
    public List createObjectNodes(IDescriptors desc) {
        Iterator i;
        List result;
        String uri;
        
        if (!desc.getUuri().equals(uuri)) {
            throw new XAssertionFailed(desc.getUuri() + "!=" + uuri);
        }
        result = new ArrayList();
        i = mapping.iterator();
        while (i.hasNext()) {
            uri = (String) i.next();
            result.add(desc.getObjectNode("/" + uri));
        }
        return result;
    }
}

