/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XDescriptorsMappingList.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;


import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.store.tamino.common.IDescriptorsHandler;
import org.apache.slide.store.tamino.common.XResolver;
import org.apache.slide.store.tamino.jdomobjects.XTLock;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;
import org.apache.slide.util.nodeset.NodeSet;



/**
 * (Descriptors, Uri+)*
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XDescriptorsMappingList {
    public static XDescriptorsMappingList create (IDescriptorsHandler handler,
                                                  String uri, NodeSet nodeSet)
        throws XException
    {
        IDescriptors root;
        XDescriptorsMappingList result;
        Iterator nodes;
        
        result = new XDescriptorsMappingList(handler);
        // strip server prefix -- TODO: server prefix size != 1?
        uri = new XUri(uri).suburi(1).toString();
        root = XResolver.create(handler, uri).run(XTLock.NO_LOCK, XTLock.NO_LOCK, false);
        if (root != null) {
            try {
                nodes = nodeSet.list(DescriptorsNode.createRoot(uri, root.getUuri())).iterator();
            } catch (NodeSetException e) {
                throw e.getException();
            } catch (IOException e) {
                throw new XAssertionFailed(e);
            }
            while (nodes.hasNext()) {
                result.add((DescriptorsNode) nodes.next());
            }
        } else {
            // do nothing - empty list
        }
        
        return result;
    }
    
    //--
    
    private final IDescriptorsHandler handler;
    private final List items;
    
    public XDescriptorsMappingList(IDescriptorsHandler handler) {
        this.handler = handler;
        this.items = new ArrayList();
    }
    
    //--
    
    public XDescriptorsMapping lookup(String uuri) {
        int i;
        int max;
        XDescriptorsMapping item;
        
        max = items.size();
        for (i = 0; i < max; i++) {
            item = (XDescriptorsMapping) items.get(i);
            if (uuri.equals(item.getUuri())) {
                return item;
            }
        }
        return null;
    }
    
    //--
    
    public String getScopeQuery() {
        StringBuffer buffer;
        Iterator i;
        XDescriptorsMapping item;
        
        buffer = new StringBuffer();
        i = items.iterator();
        if (i.hasNext()) {
            buffer.append("(");
            buffer.append(((XDescriptorsMapping) i.next()).getQuery());
            while (i.hasNext()) {
                buffer.append(" or ");
                item = (XDescriptorsMapping) i.next();
                buffer.append(item.getQuery());
            }
            buffer.append(")");
        } else {
            buffer.append("false");
        }
        return buffer.toString();
    }
    
    public void add(DescriptorsNode node) throws XException {
        String uuri;
        XDescriptorsMapping item;

        uuri = node.getUuri();
        item = lookup(uuri);
        if (item == null) {
            item = new XDescriptorsMapping(uuri);
            items.add(item);
        }
        item.add(node.uri);
    }
}




