/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XEmptyExpression.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.basic.expression.ComparedProperty;
import org.apache.slide.search.basic.IBasicExpression;

/**
 * Abstract base class for compare expressions (property compares, contains).
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XEmptyExpression extends XPropertyExpression {

    /** the operator for this compare, i. e. "=" */
    protected String operator;

    /** the property to be compared */
    protected ComparedProperty comparedProperty;

    /** indicates, if this is not-xxx expression */
    protected boolean isNot;

    /**
     * Creates a compare expression according to Element e.
     */
    XEmptyExpression () throws InvalidQueryException {
    }

    /**
     * creates the filter for this query string.
     *
     * @return   an xpath filter
     *
     */
    protected String createQueryString (String slidePath) {
        return getCollectionPrefix() + "[" + getScopeFilter (slidePath) + "]";
    }


    /**
     * Checks, if another expression may be merged (and, or) with this
     * expression into one Tamino query.
     *
     * @param    otherExpression     an IBasicExpression
     *
     * @return   true if otherExpression is instanceof XCompareExpression
     *
     */
    protected boolean isMergeable (IBasicExpression otherExpression) {

        if (otherExpression instanceof XCompareExpression)
            return true;
        else
            return false;
    }

    /**
     * Method getXpathFilter
     *
     * @return   empty filter
     *
     */
    String getXpathFilter() {
        return "";
    }


}
