/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XIsPropertyTypeExpression.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.search.basic.expression.ComparedProperty;

import org.jdom.Element;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.content.NodeProperty.NamespaceCache;
import org.apache.slide.search.basic.Literals;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.schema.XKnownPropertyHelper;

/**
 * Represents an is-principal expression. is-principal is an extension to DASL,
 * usefull for SECURITY issues.
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XIsPropertyTypeExpression extends XCompareExpression {

    /**
     * Creates an is-principal expression
     *
     * @param e jdom element, that describes the expression
     *
     */
    protected XIsPropertyTypeExpression (Element e, String propertyType)
        throws InvalidQueryException {
        this (e, propertyType, false);
    }

    /**
     * Creates an is-principal expression
     *
     * @param e jdom element, that describes the expression
     * @param isNot if true, a not-isprincipal expression is created
     *
     */
    protected XIsPropertyTypeExpression (Element e,
                                         String propertyType,
                                         boolean isNot)
        throws InvalidQueryException {
        this.expressionElement = e;
        this.isNot = isNot;
        comparedProperty = new ComparedProperty ();
        comparedProperty.setProperty (Literals.RESOURCETYPE);
        comparedProperty.setPropNamespace (NamespaceCache.DEFAULT_URI);
        operator = XBasicExpressionFactory.OP_LIKE;
        comparedProperty.setLiteral ("*" + propertyType + "*");
    }

    /**
     * creates the filter for this query string. CAUTION: only the shadow is
     * searched for the resourcetype string
     *
     * @return   an xpath filter
     *
     */
    protected String getXpathFilter() {
        StringBuffer sb = new StringBuffer ();

        String propName = comparedProperty.getProperty();
        String propNamespace = comparedProperty.getPropNamespace();
        boolean isKnown = knownProperties.isKnown (propName, propNamespace);
        createPropNamespace (sb, propName, propNamespace, isKnown);

        if (isKnown)
            sb.append (" [");

        if (isNot) {

            if (!isKnown)
                sb.append ("and ");

            sb.append ("not (");
            sb.append (createExpression ("shadow", XGlobals.MAX_SHADOW_SIZE));
            sb.append (")");
        }
        else {
            sb.append (createExpression ("shadow", XGlobals.MAX_SHADOW_SIZE));
        }

        sb.append ("]");
        return sb.toString();
    }

}

