/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XLikeExpression.java,v 1.1 2004/03/25 16:18:02 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:02 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.slide.search.InvalidQueryException;
import org.jdom.Element;



public class XLikeExpression extends XCompareExpression {

    /**
     * Creates a property-contains expression.
     *
     * @param e jdom element, that describes the expression
     *
     */
    protected XLikeExpression (Element e) throws InvalidQueryException {
        this (e, false);
    }

    protected XLikeExpression (Element e, boolean isNot) throws InvalidQueryException {
        super (e, XBasicExpressionFactory.OP_LIKE, isNot);

//        if (isNot) {
//            throw new InvalidQueryException
//                ("NOT LIKE is not supported");
//        }

        String unCensoredLiteral = comparedProperty.getLiteral();

        comparedProperty.setLiteral (getTaminoPattern (unCensoredLiteral));

    }

    private static String getTaminoPattern (String unCensoredLiteral) throws InvalidQueryException {

        StringTokenizer st = new StringTokenizer (unCensoredLiteral, "/%_*", true);
        StringBuffer taminoPattern = new StringBuffer ();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();

            if ("%".equals (token))
                taminoPattern.append ("*");

            else if ("_".equals (token))
                taminoPattern.append ("*");


            else if ("/".equals (token)) {
                if (!st.hasMoreTokens())
                    throw new InvalidQueryException ("Invalid pattern: " + unCensoredLiteral);

                String nextToken = st.nextToken();

                if ("/".equals (nextToken))
                    taminoPattern.append (nextToken);

                else if ("%".equals (nextToken))
                    taminoPattern.append (nextToken);

                else if ("_".equals (nextToken))
                    taminoPattern.append (nextToken);

                else
                    throw new InvalidQueryException ("Invalid pattern: " + unCensoredLiteral);

            }
            else {
                taminoPattern.append (token);
            }
        }


        return taminoPattern.toString();
    }

    public static void main (String [] args) {


        class Tuple {
            String source;
            String expected;

            Tuple (String s1, String s2) {
                source = s1;
                expected = s2;
            }
        }

        List testlist = new ArrayList();

        System.out.println("test masking");

        testlist.add (new Tuple ("%", "*"));
        testlist.add (new Tuple ("_", "*"));
        testlist.add (new Tuple ("a%.xml", "a*.xml"));
        testlist.add (new Tuple ("%a.xml", "*a.xml"));
        testlist.add (new Tuple ("%a.x%", "*a.x*"));
        testlist.add (new Tuple ("a/%.xml", "a%.xml"));
        testlist.add (new Tuple ("a//.xml", "a/.xml"));
        testlist.add (new Tuple ("a//%.xml", "a/*.xml"));
//        testlist.add (new Tuple ("a/", " "));
//        testlist.add (new Tuple ("a/a", " "));



        Iterator it = testlist.iterator();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            try {
                String result = getTaminoPattern (t.source);
                System.out.print (t.source + " ==> " + result);
                if (t.expected.equals (result))
                    System.out.println("   OK ");
                else
                    System.out.println("   FAILED");
            } catch (InvalidQueryException e) {
                e.printStackTrace();
            }

        }






    }




}

