/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XNotNormalizer.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.content.NodeProperty.NamespaceCache;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.basic.NotNormalizer;
import org.jdom.Element;
import org.jdom.Namespace;
import org.apache.slide.search.basic.Literals;

/**
 * Negates Tamino xdav specific query expressions.
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XNotNormalizer extends NotNormalizer {


    /**
     * Returns the negation of the given <code>expressionElement</code>.
     *
     * @param      expressionElement  the Element to return the appropriate
     *                                negation for.
     *
     * @return     the negation of the given <code>expressionElement</code>.
     *
     * @throws     BadQueryException  if the Element could not be processed.
     */
    protected Element getNegatedQueryElement(Element expressionElement) throws BadQueryException {

        if (XGlobals.TAMINO_NAMESPACE_URI.equals(expressionElement.getNamespaceURI())) {
            return getNegatedTaminoQueryElement(expressionElement);
        }
        if (NamespaceCache.DEFAULT_URI.equals(expressionElement.getNamespaceURI())) {
            return getNegatedDAVQueryElement(expressionElement);
        }
        else {
            return super.getNegatedQueryElement(expressionElement);
        }


    }

    /**
     * Returns the negation of the given <code>expressionElement</code>,
     * which is in the <code>DAV:</code> namespace.
     *
     * @param      expressionElement  the Element to return the appropriate
     *                                negation for.
     *
     * @return     the negation of the given <code>expressionElement</code>.
     *
     * @throws     BadQueryException  if the Element could not be processed.
     */
    protected Element getNegatedTaminoQueryElement (Element expressionElement) throws BadQueryException {

        String name = expressionElement.getName();

        if (XLiterals.XPATH.equals(name)) {

            Namespace taminoNamespace = Namespace.getNamespace (XGlobals.TAMINO_NAMESPACE_URI);
            Element notXPathElem =
                getNamedClone (expressionElement, XLiterals.NOT_XPATH, taminoNamespace);

            Element andElem     = new Element (XLiterals.AND, NamespaceCache.DEFAULT_NAMESPACE);
            Element eqElem      = new Element (XLiterals.EQ, NamespaceCache.DEFAULT_NAMESPACE);
            Element propElem    = new Element (XLiterals.PROP, NamespaceCache.DEFAULT_NAMESPACE);
            Element isXmlElem   = new Element ("isXml", XGlobals.TAMINO_NAMESPACE_URI);
            Element literalElem = new Element (XLiterals.LITERAL, NamespaceCache.DEFAULT_NAMESPACE);
            literalElem.addContent ("true");
            propElem.addContent (isXmlElem);
            eqElem.addContent (propElem);
            eqElem.addContent (literalElem);
            andElem.addContent (eqElem);
            andElem.addContent (notXPathElem);

            return andElem;
        }

        return getNamedClone(expressionElement, expressionElement.getName(), expressionElement.getNamespace());
    }

    /**
     * Handles optional DAV expressions, that are only implemented for Tamino
     *
     * @param    expressionElement   an Element
     *
     * @return   an Element
     *
     */
    protected Element getNegatedDAVQueryElement (Element expressionElement) throws BadQueryException{
        String name = expressionElement.getName();

        if (XLiterals.LIKE.equals(name)) {
            return getNamedClone(expressionElement, Literals.NOT_LIKE, NamespaceCache.DEFAULT_NAMESPACE);
        }

        return super.getNegatedDAVQueryElement (expressionElement);

    }


}

