/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XPathExpression.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.XContentId;
import java.util.Iterator;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicQuery;
import org.jdom.Element;

/**
 * An Expression that queries content with xpath.
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XPathExpression extends XPropertyExpression {

    /** the content query */
    private XPathContentQuery contentQuery;

    private boolean isNot = false;

    /**
     * Constructs an XPathExpression.
     *
     * @param e the element describing the expression
     *
     * @param query the BasicQuery this expression belongs to.
     */
    protected XPathExpression (Element e, IBasicQuery query) throws BadQueryException {
        this (e, query, false);
    }

    /**
     * Constructs an XPathExpression.
     *
     * @param e the element describing the expression
     *
     * @param query the BasicQuery this expression belongs to.
     */
    protected XPathExpression (Element e, IBasicQuery query, boolean isNot)
        throws BadQueryException {
        this.expressionElement = e;
        contentQuery = ((XBasicQueryImpl)query).getContentQuery(e);
        this.isNot = isNot;
    }

    /**
     * Method isMergeable
     *
     * @param    otherExpression     an IBasicExpression
     *
     * @return   true if this and other expression can be merged to one tamino request
     *
     */
    boolean isMergeable(IBasicExpression otherExpression) {
        return true;
    }

    /**
     * Method getXpathFilter
     *
     * @return   a String
     *
     * @throws   SearchException
     *
     */
    String getXpathFilter() throws SearchException {
        StringBuffer sb = new StringBuffer();

        if (query.isLimitDefined()) {
            contentQuery.execute (query.getLimit());
        }
        else
            contentQuery.execute();

        Iterator it = contentQuery.contentIdIterator();

        if (it.hasNext()) {
            sb.append ("//descriptor/propertyList/" +
                           XGlobals.TAMINO_NAMESPACE_PREFIX + ":" +
                           XGlobals.CONTENT_ID);

            if (isNot) {
                sb.append ("[not (");
            }
            else {
                sb.append ("[(");
            }

            while (it.hasNext()) {
                sb.append ("./shadow=\"");

                XContentId id = (XContentId)it.next();
                // System.out.println(id);
                sb.append (id.toString());
                sb.append ("\"");

                if (it.hasNext()) {
                    sb.append (" or ");
                }
            }
            sb.append (")]");
        }

        else {
            if (isNot) {
                sb.append ("not (false)");
            }
            else {
                sb.append ("false");
            }
        }

        // System.out.println(sb);
        return sb.toString();
    }
}
