/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XPathProperty.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.common.RequestedPropertyImpl;


/**
 * Represents an xpath requested property, for example:
 * <xsv:xpath>/cd[@artist="Frank Zappa"]</xsv:xpath>
 *
 * @author <a href="mailto:martin.wallmer@softwareag.com">Martin Wallmer</a>
 * @version $Revision: 1.3 $
 */
public class XPathProperty extends RequestedPropertyImpl {

    private XPathContentQuery contentQuery;
//    private boolean references = false;
//    private int id;
//    private int refId;


    private boolean isUnwrap = false;


    /**
     * Constructs an XPathProperty
     */
    public XPathProperty (XPathContentQuery contentQuery) {
        super (contentQuery.getQueryName().getName(),
               contentQuery.getQueryName().getNamespace());

        this.contentQuery = contentQuery;

    }



    public void setUnwrap (boolean z) {
        isUnwrap = z;
    }

    public boolean isUnwrap () {
        return isUnwrap;
    }

    public void setNamespace (String ns) {
        this.namespace = ns;
    }


    /**
     * Method getXContentQuery
     *
     * @return   a XContentQuery
     *
     */
    public XPathContentQuery getXPathContentQuery () {
        return contentQuery;
    }
}


