/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/XPathPropertyMapper.java,v 1.3 2004/07/30 06:51:58 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:58 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.search;

/**
 *
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.store.ISlideAccessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.slide.common.PropertyName;

/**
 * Manages XPath - Property mappings. An XPath - property mapping maps a property
 * (i.e. myNamespace:myProperty) to an XPath expression. If a such a property
 * is requested in the SEARCH, the caller of XPathPropertyMapper may get the
 * XPath expression and issue it on the content XML document.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class XPathPropertyMapper
{
    private static Map mappings = new HashMap ();
    static {
        mappings.put (new PropertyName (XGlobals.NIXE_META, XGlobals.TAMINO_NAMESPACE_URI),
                      "/xdav_nonXML/properties/meta");
    }
    
    /**
     * Method getInstance
     *
     * @param    slide               could be used to get configured mappings
     *
     * @return   a XPathPropertyMapper
     *
     */
    static XPathPropertyMapper getInstance (ISlideAccessor slide) {
        return new XPathPropertyMapper ();
    }
    
    /**
     * Method getMapping
     *
     * @param    propName            a  PropertyName
     *
     * @return   a String
     *
     */
    String getMapping (PropertyName propName) {
        return (String) mappings.get (propName);
    }
}

