/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/jdomobjects/XJdom.java,v 1.3 2004/07/30 06:52:00 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:00 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.jdomobjects;

import org.apache.slide.store.tamino.common.XGlobals;
import java.text.SimpleDateFormat;
import org.jdom.Namespace;

/**
 * Describes the XDescriptorsStore's view to a Descriptors object.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public interface XJdom {

    /** node type "branch" */
    static final String E_BRANCH          = "branch";
    /** node type "branchList" */
    static final String E_BRANCHLIST      = "branchList";
    /** node type "childNode" */
    static final String E_CHILD_NODE      = "childNode";
    /** node type "children" */
    static final String E_CHILDREN        = "children";
    /** node type "descriptorList" */
    static final String E_PARENT_NODE     = "parentNode";
    /** node type "children" */
    static final String E_PARENTS         = "parents";
    /** node type "descriptorList" */
    static final String E_DESCRIPTOR_LIST = "descriptorList";
    /** node type "initialRevision" */
    static final String E_INITIAL_REVISION= "initialRevision";
    /** node type "label" */
    static final String E_LABEL           = "label";
    /** node type "labels" */
    static final String E_LABELS          = "labels";
    /** node type "latestRevision" */
    static final String E_LATEST_REVISION = "latestRevision";
    /** node type "latestList" */
    static final String E_LATEST_LIST     = "latestList";
    /** node type "links" */
    static final String E_LINKS           = "links";
    /** node type "locks" */
    static final String E_LOCKS           = "locks";
    /** node type "objectNode" */
    static final String E_OBJECT_NODE     = "objectNode";
    /** node type "nodeLock"*/
    static final String E_NODE_LOCK       = "nodeLock";
    /** node type "nodePermission" */
    static final String E_NODE_PERMISSION = "nodePermission";
    /** node type "nodeProperty" */
    static final String E_NODE_PROPERTY   = "nodeProperty";
    /** node type "permissions" */
    static final String E_PERMISSIONS     = "permissions";
    /** node type "propertyList" */
    static final String E_PROPERTY_LIST   = "propertyList";
    /** node type "descriptor" */
    static final String E_REVISION_DESCRIPTOR  = "descriptor";
    /** node type "descriptors" */
    static final String E_REVISION_DESCRIPTORS = "descriptors";
    /** node type "e-revisionNumber" */
    static final String E_REVISION_NUMBER      = "revisionNumber";
    /** node type "shadow" */
    static final String E_SHADOW               = "shadow";
    /** node type "successor" */
    static final String E_SUCCESSOR            = "successor";


    /** node type "action" */
    static final String A_ACTION          = "action";
    /** node type "actionUri" */
    static final String A_ACTION_URI      = "actionUri";
    /** node type "aspects" */
    static final String A_ASPECTS         = "aspects";
    /** node type "branchName" */
    static final String A_BRANCH_NAME     = "branchName";
    /** node type "datatype" */
    static final String A_DATATYPE        = "datatype";
    /** node type "depth" */
    static final String A_DEPTH           = "depth";
    /** node type "dtdVersion" */
    public static final String A_DTD_VERSION        = "dtdVersion";
    /** node type "expirationDate" */
    static final String A_EXP_DATE        = "expirationDate";
    /** node type "exclusive"*/
    static final String A_EXCLUSIVE       = "exclusive";
    /** node type "onwerInfo"*/
    static final String A_OWNER_INFO      = "ownerInfo";
    /** node type "inheritance" */
    static final String A_INHERITANCE     = "inheritance";
    /** node type "kind" */
    static final String A_KIND            = "kind";

    /** node type "link" */
    static final String A_LAST_PATHSEGMENT = "lastPathSegment";

    /** node type "link" */
    static final String A_LINK            = "link";
    
    /** node type "lockId" */
    static final String A_LOCKID          = "lockId";
    /** node type "name" */
    static final String A_NAME            = "name";
    /** node type "namespace" */
    static final String A_NAMESPACE       = "namespace";
    /** node type "negative" */
    static final String A_NEGATIVE        = "negative";
    /** node type "protected" */
    static final String A_PROTECTED      = "protected";
    /** node type "revisionNumber" */
    static final String A_REVISION_NUMBER = "revisionNumber";
    /** node type "isVersioned" */
    static final String A_IS_VERSIONED    = "isVersioned";

    /** node type "subject" */
    static final String A_SUBJECT         = "subject";
    /** node type "subjectUri" */
    static final String A_SUBJECT_URI     = "subjectUri";
    /** node type "type" */
    static final String A_TYPE            = "type";
    /** node type "typeUri" */
    static final String A_TYPE_URI        = "typeUri";
    /** node type "uri" */
    static final String A_URI             = "uri";
    /** node type "uriRef" */
    static final String A_URIREF          = "uriRef";

    /** constant "true" */
    static final String TRUE              = "true";
    /** constant "false" */
    static final String FALSE             = "false";
    /** constant "string" */
    static final String STRING            = "string";
    /** constant "int" */
    static final String INT               = "int";
    /** constant "long" */
    static final String LONG              = "long";
    /** constant "boolean" */
    static final String BOOLEAN           = "boolean";
    /** constant "date" */
    static final String DATE              = "date";
    /** constant "date" */
    static final String XML               = "xml";

    /** used for string representation of dates */
    static final SimpleDateFormat DATE_FORMATTER =
        new SimpleDateFormat ("yyyyMMddHHmmss");
    
    /** XSV namespace */
    static final Namespace XSV_NAMESPACE =
        Namespace.getNamespace (XGlobals.TAMINO_NAMESPACE_PREFIX, XGlobals.TAMINO_NAMESPACE_URI);

    /** jdom aspect */
}



