/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/jdomobjects/XNodeLock.java,v 1.1 2004/03/25 16:18:02 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:02 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.jdomobjects;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.util.XAssertionFailed;
import org.jdom.Element;

/**
 * Serialize NodePermission to and from XML.
 */
public class XNodeLock implements XJdom {

    public static Element toXmlList(List locks) {
        Element root;
        Iterator iter;

        root = new Element(E_LOCKS);
        iter = locks.iterator();
        while (iter.hasNext()) {
            root.addContent(toXml((NodeLock) iter.next()));
        }
        return root;
    }

    public static void toStreamList(XmlStream xs, List locks) {
        Iterator iter;

        xs.addStartElement(E_LOCKS);
        xs.addEndElement();
        iter = locks.iterator();
        while (iter.hasNext()) {
            toStream(xs, (NodeLock) iter.next());
        }
        xs.addCloseElement(E_LOCKS);
    }

    /**
     ** Serializes to Xml.
     **
     ** @return an element
     **/
    public static Element toXml (NodeLock lock) {
        String expDate;
        Element element;

        synchronized (DATE_FORMATTER) {
            expDate = DATE_FORMATTER.format (lock.getExpirationDate());
        }

        element = new Element (E_NODE_LOCK);
        element.setAttribute (A_LOCKID,      lock.getLockId());
        // objectUri is not stored!
        element.setAttribute (A_SUBJECT_URI, lock.getSubjectUri());
        element.setAttribute (A_TYPE_URI,    lock.getTypeUri());
        element.setAttribute (A_EXP_DATE,    expDate);
        element.setAttribute (A_INHERITANCE, lock.isInheritable() ? TRUE : FALSE);
        element.setAttribute (A_EXCLUSIVE,   lock.isExclusive() ? TRUE : FALSE);
        element.setAttribute (A_OWNER_INFO,  lock.getOwnerInfo() != null ? lock.getOwnerInfo() : "");

        return element;
    }

    public static void toStream (XmlStream xs, NodeLock lock) {
        String expDate;

        synchronized (DATE_FORMATTER) {
            expDate = DATE_FORMATTER.format (lock.getExpirationDate());
        }
        
        xs.addStartElement(E_NODE_LOCK);
        xs.addAttribute(A_LOCKID,      lock.getLockId());
        // objectUri is not stored!
        xs.addAttribute(A_SUBJECT_URI, lock.getSubjectUri());
        xs.addAttribute(A_TYPE_URI,    lock.getTypeUri());
        xs.addAttribute(A_EXP_DATE,    expDate);
        xs.addAttribute(A_INHERITANCE, lock.isInheritable());
        xs.addAttribute(A_EXCLUSIVE,   lock.isExclusive());
        xs.addAttribute(A_OWNER_INFO,  lock.getOwnerInfo() != null ? lock.getOwnerInfo() : "");
        xs.addEndElement();
        xs.addCloseElement(E_NODE_LOCK);
    }

    public static NodeLock toSlide(Element nodeLock) {
        Date expDate;
        try {
            synchronized (DATE_FORMATTER) {
                expDate = DATE_FORMATTER.parse (nodeLock.getAttributeValue(A_EXP_DATE));
            }
        } catch (ParseException e) {
            throw new XAssertionFailed(e);
        }

        return
            new NodeLock(nodeLock.getAttributeValue(A_LOCKID),
                         null,
                         nodeLock.getAttributeValue(A_SUBJECT_URI),
                         nodeLock.getAttributeValue(A_TYPE_URI),
                         expDate,
                         nodeLock.getAttributeValue
                             (A_INHERITANCE).equals (TRUE) ? true : false,
                         nodeLock.getAttributeValue
                             (A_EXCLUSIVE).equals (TRUE) ? true : false,
                         nodeLock.getAttributeValue(A_OWNER_INFO));

    }

    /**
     * get all permissions for this resource
     *
     * @return      Enumeration containing all permissions
     */
    public static List toSlideListExtract (Element root) {
        List xml = root.getChild(E_LOCKS).getChildren();
        List slide = new ArrayList(xml.size());
        Iterator it = xml.iterator();
        while (it.hasNext()) {
            slide.add (toSlide((Element)it.next()));
        }
        return slide;
    }
}


