/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/jdomobjects/XmlStream.java,v 1.1 2004/03/25 16:18:02 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:02 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.jdomobjects;

import org.jdom.output.XMLOutputter;

public class XmlStream {
    private final StringBuffer sb;
    
    /**
     * We need JDOM's escaperElement/AttributeEntities methods. Unfortunatly, these
     * methods are not static, this, we need to create an outputter ...
     **/
    private final XMLOutputter escaper;
    
    public XmlStream() {
        this.sb = new StringBuffer();
        this.escaper = new XMLOutputter();
    }

    public void addStartElement(String name) {
        sb.append('<');
        sb.append(name);
    }
    
    public void addStartElement(String name, String namespace, String prefix) {
        sb.append('<');
        sb.append(name);
        if (prefix == null || prefix.length() == 0) {
            sb.append(" xmlns=\"");
        } else {
            sb.append(" xmlns:");
            sb.append(prefix);
            sb.append("=\"");
        }
        sb.append(namespace);
        sb.append('"');
    }

    public void addEndElement() {
        sb.append('>');
    }
    
    public void addCloseElement(String name) {
        sb.append("</");
        sb.append(name);
        sb.append('>');
    }
    public void addCloseElement(String name, String prefix) {
        sb.append("</");
        sb.append(prefix);
        sb.append(':');
        sb.append(name);
        sb.append('>');
    }
    
    public void addAttribute(String name, boolean value) {
        sb.append(' ');
        sb.append(name);
        sb.append(value? "=\"true\"" : "=\"false\"");
    }

    public void addAttribute(String name, String value) {
        addAttributeUnescaped(name, escaper.escapeAttributeEntities(value));
    }

    public void addAttributeUnescaped(String name, String value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(escaper.escapeAttributeEntities(value));
        sb.append('"');
    }
    
    public void addText(String str) {
        sb.append(escaper.escapeElementEntities(str));
    }
    
    public String toString() {
        return sb.toString();
    }
}

