/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/security/admin/StoreInfo.java,v 1.3 2004/07/30 06:52:01 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:01 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.security.admin;

import org.apache.slide.urm.common.URMPrincipal;
import java.util.Vector;

/**
 ** This class is used for storing activities of a principal
 **
 ** @author    josef.haiduk@softwareag.com
 ** @version   $Revision: 1.3 $
 **
 **/

public class StoreInfo
{
	URMPrincipal principal = null;
	Vector usersBeingCreated = new Vector();
	Vector groupsBeingCreated = new Vector();
	Vector rolesBeingCreated = new Vector();
	Vector actionsBeingCreated = new Vector();
	

	/**
	 * Constructor
	 *
	 * @param    principal           an URMPrincipal
	 *
	 */
	StoreInfo(URMPrincipal principal) {
		this.principal = principal;
	}
	
	/**
	 * Method getPrincipal
	 *
	 * @return   an URMPrincipal
	 *
	 */
	URMPrincipal getPrincipal()
	{
		return principal;
	}
	
	/**
	 * Method storeUserBeingCreated
	 *
	 * @param    gate                an URMUsersGate
	 *
	 */
	void storeUserBeingCreated(URMUsersGate gate)
	{
		usersBeingCreated.add(gate);
	}
	
	/**
	 * Method getUsersBeingCreated
	 *
	 * @return   a Vector
	 *
	 */
	Vector getUsersBeingCreated()
	{
		return usersBeingCreated;
	}
	
	/**
	 * Method clearUsersBeingCreated
	 *
	 */
	void clearUsersBeingCreated() {
		usersBeingCreated = new Vector();
	}
	
	/**
	 * Method storeGroupBeingCreated
	 *
	 * @param    gate                an URMGroupsGate
	 *
	 */
	void storeGroupBeingCreated(URMGroupsGate gate)
	{
		groupsBeingCreated.add(gate);
	}
	
	/**
	 * Method getGroupsBeingCreated
	 *
	 * @return   a Vector
	 *
	 */
	Vector getGroupsBeingCreated()
	{
		return groupsBeingCreated;
	}
	
	/**
	 * Method clearGroupsBeingCreated
	 *
	 */
	void clearGroupsBeingCreated() {
		groupsBeingCreated = new Vector();
	}
	
	/**
	 * Method storeRoleBeingCreated
	 *
	 * @param    gate                an URMRolesGate
	 *
	 */
	void storeRoleBeingCreated(URMRolesGate gate)
	{
		rolesBeingCreated.add(gate);
	}
	
	/**
	 * Method getRolesBeingCreated
	 *
	 * @return   a Vector
	 *
	 */
	Vector getRolesBeingCreated()
	{
		return rolesBeingCreated;
	}
	
	/**
	 * Method clearRolesBeingCreated
	 *
	 */
	void clearRolesBeingCreated() {
		rolesBeingCreated = new Vector();
	}
	
	/**
	 * Method storeActionsBeingCreated
	 *
	 * @param    gate                an URMActionsGate
	 *
	 */
	void storeActionsBeingCreated(URMActionsGate gate)
	{
		actionsBeingCreated.add(gate);
	}
	
	/**
	 * Method getActionsBeingCreated
	 *
	 * @return   a Vector
	 *
	 */
	Vector getActionsBeingCreated()
	{
		return actionsBeingCreated;
	}
	
	/**
	 * Method clearActionsBeingCreated
	 *
	 */
	void clearActionsBeingCreated() {
		actionsBeingCreated = new Vector();
	}
}

