/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/servlet/XWebdavServletSerialised.java,v 1.3 2004/07/30 06:52:03 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:03 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 ** Adds monitoring.
 **
 ** @author    peter.nevermann@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XWebdavServletSerialised extends XWebdavServlet {
    
   /**
     * all commands may be executed in parallel, except for move and delete
     * where exactely one command (either move, or delete) may be executed
     **/
    private static Object writeMethodSynchronisationHack = new Object();
    
    
    
    /**
     * Overwrites in order to perform monitoring.
     * @param req http servlet request
     * @param resp http servlet response
     * @exception ServletException error in the servlet
     * @exception IOException IO error
     */
    protected void service (HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException {
        
        String m = req.getMethod();
        
        if (m.equalsIgnoreCase("delete") ||
            m.equalsIgnoreCase("put")    ||
            m.equalsIgnoreCase("copy")   ||
            m.equalsIgnoreCase("move")    ) {
            synchronized (writeMethodSynchronisationHack) {
                super.service( req, resp );
            }
        } else {
            super.service( req, resp );
        }
        
        
    }
    
    
}


