/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/ISlideAccessor.java,v 1.4 2004/09/15 14:58:25 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2004/09/15 14:58:25 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store;

import org.apache.slide.common.Namespace;

/**
 * Provides access to information coming from slide. These are mainly
 * configuration data as Tamino connection info and collection for
 * content data.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.4 $
 */

public interface ISlideAccessor {
    
    /**
     * Get the Domain parameter (from Domain.xml) given by name.
     *
     * @param   name   the parameter name
     * @return  the parameter value
     */
    public String getParameter( String name );
    
    /**
     * Get the associated namespace access token.
     * @return     the namespace access token
     */
    public String getNamespaceName();
    
    /**
     * Method getNamespace
     *
     * @return   a Namespace
     */
    public Namespace getNamespace();
}

