/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/AbstractMonitorable.java,v 1.3 2004/07/30 06:52:03 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:03 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.slide.util.ClassName;


/**
 ** Helper class to easy the implementation of monitorables.
 **
 ** @author  Peter.Nevermann@softwareag.com
 ** @version 0.1
 **
 **/
public class AbstractMonitorable implements IMonitorable {
    
    private static final String LOGNAME = LoggerUtil.getThisClassName();
    private static final String CLASSNAME = new ClassName(LOGNAME).getPlainName();
    private static Logger logger = LoggerFactory.getLogger(LOGNAME);
    
    /** the name */
    protected String monName = "";
    /** the parent */
    protected IMonitorable monParent = null;
    /** the children */
    protected List monChildren = new ArrayList();
    /** the Monitor object */
    protected Monitor monitor = null;

    
    /**
     ** Set the parent monitorable.
     **
     ** @param parent  the parent
     **
     **/
    public void setParent( IMonitorable parent ) {
        this.monParent = parent;
    }
    
    
    //-------------------------------------------------------------
    // IMonitorable interface
    // ------------------------------------------------------------
    
    /**
     ** Return the name of this monitorable.
     **
     ** @return the name
     **
     **/
    public String getMonName() {
        return monName;
    }
    
    /**
     ** Get the parent monitorable.
     **
     ** @return the parent, null if none
     **
     **/
    public IMonitorable getMonParent() {
        return monParent;
    }
    
    /**
     ** Get child monitorables.
     **
     ** @return  the children
     **
     **/
    public List getMonChildren() {
        return monChildren;
    }
    
    /**
     ** Get the Monitor object.
     **
     ** @return the monitor object
     **
     **/
    public IMonitor getMonitor() {
        return monitor;
    }
        
    /**
     ** Get the value of a registered property.
     ** @param prop  name of the property
     ** @return the value of the indicated property as String
     **
     **/
    public Object getMonProperty( String prop ) {
        return null;
    }
}
