/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/IMonitor.java,v 1.3 2004/07/30 06:52:03 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:03 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

import org.jdom.Element;

/**
 ** Manages one or more monitored items (counters, timers, etc.).
 **
 ** @author  Peter.Nevermann@softwareag.com
 ** @version 0.1
 ** @see IMonitorable
 **
 **/
public interface IMonitor {
    
    /**
     ** Get the monitored object.
     **
     ** @return the monitored object
     **
     **/
    IMonitorable getMonitored();
    
    /**
     ** Creates a snapshot as XML string.
     **
     ** @return a snapshot as XML string
     ** @exception IOException
     **
     **/
    String snapshotXML() throws java.io.IOException;
    
    /**
     * Creates a snapshot element
     *
     * @return   a snapshot element
     *
     */
    Element snapshotElement();
    
    /**
     ** Reset all monitored items of this monitor.
     **
     **/
    void resetAllItems();
    
    /**
     ** Reset the specified monitored item.
     **
     ** @param      name the item name
     **
     **/
    void resetItem( String name );
    
    /**
     ** Enable/disable all monitored items.
     **
     ** @param      enabled if true, all items are enabled
     **
     **/
    void setEnabled( boolean enabled );
    
    /**
     ** Enable/disable the specified monitored item.
     **
     ** @param      enabled if true, the givne item is enabled
     ** @param      name the item name
     **
     **/
    void setEnabled( boolean enabled, String name );
}
