/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/IMonitorable.java,v 1.3 2004/07/30 06:52:03 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:03 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

import java.util.List;

/**
 ** A monitored object (component).
 **
 ** @author  Peter.Nevermann@softwareag.com
 **
 ** @version $Revision: 1.3 $
 **
 **/
public interface IMonitorable {
    
    /**
     ** Get the name of this monitorable.
     **
     ** @return the name of this monitorable
     **
     **/
    String getMonName();
    
    /**
     ** Get the parent monitorable.
     **
     ** @return the parent monitorable (IMonitorable), null if none
     **
     **/
    IMonitorable getMonParent();
    
    /**
     ** Get the child monitorables.
     **
     ** @return list of child monitorables (IMonitorable), empty list if none
     **
     **/
    List getMonChildren();
    
    /**
     ** Get the monitor.
     **
     ** @return the monitor to this object
     **
     **/
    IMonitor getMonitor();
    
    /**
     ** Get the value of a registered property.
     **
     ** @param  prop the property name
     ** @return the value of the indicated property as String
     **
     **/
    Object getMonProperty( String prop );
}
