/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/MonitoredCounter.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;


/**
 ** A counter item.
 **
 ** @author  Martin.Wallmer.com
 ** @version 0.1
 **/
public class MonitoredCounter extends MonitoredItem {
    
    /**
     ** Default constructor.
     ** @param name      name of the counter
     ** @param monitor   monitored object
     **/
    public MonitoredCounter (String name, IMonitor monitor) {
        super (name, monitor);
    }
    
    /**
     ** increment this counter by 1.
     **
     ** @pre
     ** @post
     **
     **/
    public synchronized void increment () {
        increment(1);
    }
    
    /**
     ** Increments this counter by the indicated value
     **
     ** @param      i the amount to increment
     **
     **/
    public synchronized void increment (long i) {
        if (enabled)
            value = value + i;
    }
    
    /**
     ** Decrement this counter by 1.
     **
     **/
    public synchronized void decrement () {
        decrement(1);
    }
    
    /**
     ** Decrements this counter by the indicated value
     **
     ** @param      i the amount to decrement
     **
     **/
    public synchronized void decrement (long i) {
        if (enabled)
            value = value - i;
    }
           
    /**
     ** Returns string representation of this object.
     ** @return string representation of this object.
     **/
    public String toString() {
        return "Counter_"+name;
    }
}
