/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/MonitoredItem.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

/**
 ** Abstract base class for a monitored item of a Monitor.
 ** Items can be timers or counters.
 **
 ** @author  Martin.Wallmer@softwareag.com
 ** @version 0.1
 **
 **/
public abstract class MonitoredItem implements Comparable {
    
    /** the value of this item (value of the counter, cumulated time of timer, etc.) */
    protected long value;
    
    /** the name of this item. It may be displayed by ARGUS
     ** and be used to identify for en-disabling
     **/
    protected String name;
    
    /** the Monitor object, this item belongs to */
    protected IMonitor theMonitor;
    
    /** the state of the item */
    protected boolean enabled = true;
    
    
    /**
     ** Construct a monitored item
     **
     ** @pre
     ** @post
     **
     ** @param      name the item's name
     ** @param      monitor the owner of this item
     **
     **/
    public MonitoredItem (String name, IMonitor monitor) {
        this.name = name;
        this.theMonitor = monitor;
    }
    
    /**
     ** Reset this item.
     **
     **/
    public void reset () {
        value = 0;
    }
    
    /**
     ** Enable or disable this item.
     **
     ** @param      enabled true => enable this counter false => disable this counter
     ** @return     the previous state of the counter
     **
     **/
    public boolean setEnabled (boolean enabled) {
        boolean previous = this.enabled;
        this.enabled = enabled;
        return previous;
    }
    
    /**
     ** Get the value of this item.
     **
     ** @return the items value
     **
     **/
    public Object getValue() {
        return new Long( value );
    }
    
    /**
     ** Get the name of this item.
     **
     ** @return  the items name
     **
     **/
    public String getName() {
        return name;
    }
    
    /**
     ** The comparator (implements Comparable). Compares the names.
     **
     ** @param o the Object to be compared
     ** @return a negative integer, zero, or a positive integer as this object is less than,
     ** equal to, or greater than the specified object
     **
     **/
    public int compareTo (Object o) {
        return (name.compareTo (((MonitoredItem)o).getName()));
    }
    
}
