/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/MonitoredProperty.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;


/**
 ** A Property item.
 **
 ** @author  Hardy.Kiefer@software.com
 ** @version 0.1
 **/
public class MonitoredProperty extends MonitoredItem {
    
    /**
     ** Default constructor.
     ** @param name       name of the property
     ** @param monitor    monitor object
     **/
    public MonitoredProperty (String name, IMonitor monitor) {
        super (name, monitor);
    }
    
    /**
     ** Get the value of this item.
     **
     ** @return the items value
     **
     **/
    public Object getValue() {
        return theMonitor.getMonitored().getMonProperty( name );
    }
            
    /**
     ** Returns string representation of this object.
     ** @return string representation of this object.
     **/
    public String toString() {
        return "Property_"+name;
    }
}
