/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/store/monitoring/MonitoredTimer.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

import java.util.Date;

/**
 ** A timer item.
 **
 ** @author  Martin.Wallmer.com
 ** @version 0.1
 **/
public class MonitoredTimer extends MonitoredItem {
    
    /** the time when this timer was last started, o if not running */
    // private Date startTime;
    
    private boolean isRunning = false;
    
    /**
     ** Default constructor.
     ** @param name     name of the monitor
     ** @param monitor  monitored object
     **/
    public MonitoredTimer (String name, IMonitor monitor) {
        super (name, monitor);
    }
    
    /**
     ** Starts the timer.
     ** @return the start time
     **/
    public synchronized Object start () {
        Object startTime = null;
        if (enabled) {
            isRunning = true;
            startTime = new Date();
        }
        return startTime;
    }
    
    /**
     ** Stops the timer. The cumulated time (value) is incremented by the
     ** amount of milliseconds of this run.
     **
     ** @param   startTime   start time
     **
     **/
    public synchronized void stop (Object startTime) {
        if (enabled) {
            value = value + runsMilliSeconds (startTime);
            isRunning = false;
        }
    }
    
    /**
     ** Enables/disables this timer. If the timer to be disabled and
     ** is currently running, it is stopped.
     **
     ** @param      enabled   enable or disable the timer
     ** @return     the previous state of the counter
     **
     **/
    public boolean setEnabled (boolean enabled) {
        if (enabled == false)
            stop (null);
        return super.setEnabled (enabled);
    }
    
    /**
     ** Resets this timer. If it is currently running, the start time is reset as well
     **
     **/
    public void reset () {
        if (isRunning) {
            start();
        }
        
        value = 0;
        super.reset();
    }
    
    /**
     ** Get the number of milliseconds elapsed since this timer was lastly started.
     **
     ** @return the time, this timer is running or 0, if it is currently
     **         not running
     **
     **/
    private long runsMilliSeconds (Object startTime) {
        if (startTime != null)
            return new Date().getTime() - ((Date)startTime).getTime();
        else
            return 0;
    }
    
    /**
     ** Returns string representation of this object.
     ** @return string representation of this object.
     **/
    public String toString() {
        return "Timer_"+name;
    }
}
