/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/Env.java,v 1.4 2004/09/15 16:42:07 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2004/09/15 16:42:07 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.slide.store.tamino.tools.config.WebXml;
import org.apache.slide.util.Files;
import org.apache.slide.util.MimeMapping;
import org.apache.slide.util.Misc;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;

/**
 * Reads the buildnumber (Implementation-Version) from xdav.jar's
 * manifest file.
 *
 * @author martin.wallmer@softwareag.com
 * @version 1.0
 */
public class Env {
    private static final Env singleton = new Env();
    
    public static Env get() {
        return singleton;
    }
    
    //--
    
    /** never null */
    public final String home;
    private MimeMapping mimeMapping;
    
    private Env() {
        home = locateWebappHome().getPath();
    }
    
    public MimeMapping getMimeMapping() {
        if (mimeMapping == null) {
            try {
                mimeMapping = new WebXml().readMimeMapping();
            } catch( XException x ) {
                throw new XAssertionFailed("no mime mapping: " + x.getMessage(), x);
            }
        }
        return mimeMapping;
    }
    
    
    public String getProperty(String name) {
        if (name.equals(PROPERTY_NAME)) {
            return Env.get().home;
        } else {
            return System.getProperty(name);
        }
    }
    
    /**
     * Get product information string.
     * @return product information string
     */
    public String getVersion() throws IOException {
        String jarFileName = "tws-store.jar";  // TODO
        File file = new File(getLibDirectory(), jarFileName);
        Manifest mf;
        JarFile jarFile;
        Attributes attrs;
        String name;
        String version;
        String date;
        String by;
        String host;
        
        if (file.isFile()) {
            jarFile = new JarFile (file);
            mf = jarFile.getManifest();
            attrs = mf.getMainAttributes();
            version = getAttr(attrs, "Specification-Version");
            name = getAttr(attrs, "Specification-Title");
            date = getAttr(attrs, "Built-Date");
            by = getAttr(attrs, "Built-By");
            host = getAttr(attrs, "Built-Host");
            return name + " " +
                "Version " + version + "\n(built " + date + " by " + by + " on " + host + ")\n" +
                "Copyright 1999-2004 The Apache Software Foundation.";
        } else {
            return "(no version info)";
        }
    }
    
    //--
    
    private File getLibDirectory() {
        String libDirectory;
        File file;
        
        libDirectory =
            home +
            File.separator + "WEB-INF" +
            File.separator + "lib";
        file = new File(libDirectory);
        if (!file.isDirectory()) {
            throw new RuntimeException("Cannot locate lib directory: " + libDirectory);
        }
        return file;
    }
    
    private static String getAttr(Attributes attrs, String name) {
        String value;
        
        value = attrs.getValue(name);
        if (value == null) {
            return "unkown";
        } else {
            return value;
        }
    }
    
    public static final String PROPERTY_NAME = "webapp.home";
    
    /**
     ** Locates webdav home directory, based on a property or the location of the class
     ** file of this class.
     **
     ** @return existing directory
     **/
    public static File locateWebappHome() {
        String property;
        File file;
        
        property = System.getProperty(PROPERTY_NAME);
        if (property != null) {
            System.out.println("Using system property " + PROPERTY_NAME + ": " + property);
            file = new File(property);
        } else {
            file = Misc.locateClasspathItem(Misc.class);
            if (!file.isAbsolute()) {
                throw new XAssertionFailed("absolute file expected: " + file);
            }
            file = file.getParentFile();
            file = Files.up(file, new String[] { "lib", "classes", "WEB-INF" });
            if (file == null) {
                throw new XAssertionFailed();
            }
        }
        if (!file.isDirectory()) {
            throw new XAssertionFailed("no such directory: " + file);
        }
        return file;
    }
}

