/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/Output.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.slide.util.cli.Abort;

public class Output {
    private final static PrintStream STD_OUT = System.out;
    private final static PrintStream NULL_OUT = new PrintStream(new OutputStream() {
                    public void write(int b) throws IOException {
                        // ignored
                    }
                });

    public static final String QUIET = "quiet";
    public static final String NORMAL = "normal";
    public static final String VERBOSE = "verbose";

    //--
    
    /** receives output that's printed always **/
    public final PrintStream quiet;
    
    /** receives output for normal mode -- suppressed in quiet mode */
    public final PrintStream normal;
    
    /** receives output that's only printed in verbose mode */
    public final PrintStream verbose;

    public static Output create(String mode) throws Abort {
        if (QUIET.equals(mode)) {
            return new Output(STD_OUT, NULL_OUT, NULL_OUT);
        } else if (NORMAL.equals(mode)) {
            return new Output(STD_OUT, STD_OUT, NULL_OUT);
        } else if (VERBOSE.equals(mode)) {
            return new Output(STD_OUT, STD_OUT, STD_OUT);
        } else {
            throw new Abort("invalid output mode: " + mode);
        }
    }
    
    public Output(PrintStream quiet, PrintStream normal, PrintStream verbose) {
        this.quiet = quiet;
        this.normal = normal;
        this.verbose = verbose;
    }
}
