/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/collection/ContentAdapter.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.collection;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TResponse;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;

public class ContentAdapter extends Adapter {
    public static ContentAdapter create(TConnection connection, TAccessLocation collection) {
        return new ContentAdapter(connection.newXMLObjectAccessor(collection, Collection.OBJECT_MODEL));
    }
    
    //--
    
    private final TXMLObjectAccessor acc;
    
    public ContentAdapter(TXMLObjectAccessor acc) {
        this.acc = acc;
    }
    
    public ElementIterator iterate() throws TException {
        TResponse response;
        
        response = acc.query(TQuery.newInstance("/*"));
        return new ContentIterator(response.getXMLObjectIterator());
    }
    
    public void insert(Element root) throws TInsertException {
        // TODO: verify ino id
        acc.insert(TXMLObject.newInstance(root));
    }
    
    public class ContentIterator extends ElementIterator {
        private TXMLObjectIterator iter;
        
        public ContentIterator(TXMLObjectIterator iter) {
            this.iter = iter;
        }
        
        public boolean hasNext() {
            return iter.hasNext();
        }
        
        public Element next() throws TException {
            TXMLObject xml;
            String contentType;
            
            xml = iter.next();
            contentType = xml.getContentType();
            if (!"text/xml".equals(contentType)) {
                throw new TException("unsupported content type: " + contentType);
            }
            return (Element) xml.getElement();
        }
    }
}
