/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/collection/SchemaAdapter.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.collection;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TResponse;
import java.io.IOException;
import java.util.Iterator;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class SchemaAdapter extends Adapter {
    public static SchemaAdapter create(TConnection connection, TAccessLocation collection) {
        TSchemaDefinition3Accessor acc;
        
        acc = connection.newSchemaDefinition3Accessor(Collection.OBJECT_MODEL);
        acc.setLockMode(TLockMode.PROTECTED);
        acc.setLockwaitMode(TLockwaitMode.YES);
        return new SchemaAdapter(acc, collection);
    }

    //--
    
    private final TAccessLocation collection;
    private final TSchemaDefinition3Accessor acc;
    
    public SchemaAdapter(TSchemaDefinition3Accessor acc, TAccessLocation collection) {
        this.acc = acc;
        this.collection = collection;
    }

    public void insert(Element root) throws IOException, TException, XException {
        XPath xpath;
        Attribute attr;
        
        try {
            xpath = XPath.newInstance("xs:annotation/xs:appinfo/tsd:schemaInfo/tsd:collection/@name");
            xpath.addNamespace(XGlobals.XML_SCHEMA_NAMESPACE_PREFIX, XGlobals.XML_SCHEMA_NAMESPACE_URI);
            xpath.addNamespace(XGlobals.TAMINO_TSD_3_NAMESPACE_PREFIX, XGlobals.TAMINO_TSD_3_NAMESPACE_URI);
            attr = (Attribute) xpath.selectSingleNode(root);
        } catch (JDOMException e) {
            throw new XAssertionFailed(e);
        }
        attr.setValue(collection.getCollection());
        acc.define(TXMLObject.newInstance(root));
    }

    public ElementIterator iterate() throws TException {
        return new SchemaIterator(acc.getSchemaNames(collection.getCollection()));
    }

    //--
    
    /** placed in this class because deletion needs an tsd accessor */
    public void deleteCollection() throws TUndefineException {
        acc.undefine( collection.getCollection(), null /* whole collection */);
    }

    //--
    
    public class SchemaIterator extends ElementIterator {
        private final Iterator iter;
        
        public SchemaIterator(Iterator iter) {
            this.iter = iter;
        }
        
        public boolean hasNext() {
            return iter.hasNext();
        }
        
        public Element next() throws TException {
            String name;
            TResponse response;
            
            name = (String) iter.next();
            response = acc.getSchema(collection.getCollection(), name);
            // TODO: check response code
            // TODO: check multiple object
            // TODO: use streams
            TXMLObject obj = response.getFirstXMLObject();
            return (Element) obj.getElement();
        }
    }
}

