/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/collection/StoreDir.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.collection;

import com.softwareag.tamino.db.api.common.TException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.util.Files;
import org.apache.slide.util.XException;
import org.apache.slide.util.nodeset.NodeSet;
import org.apache.slide.util.nodeset.Predicate;

/**
 * Represents webdav data for one store: the meta data collection and the content collection.
 * Provides methods to save and load this content to/from the file system.
 */
public class StoreDir {
    public static StoreDir createExisting(File dir, String uri) throws IOException {
        return new StoreDir(dir, uri, getStoreName(dir));
    }
    
    private static String getStoreName(File dir) throws IOException {
        NodeSet set;
        List lst;
        
        set = new NodeSet();
        set.include("*");
        set.predicate(new Predicate() {
                    public boolean matches(Object node) {
                        File file;
                        
                        file = (File) node;
                        return file.isDirectory() && !file.getName().equals(METADATA);
                    }
                });
        lst = set.list(dir);
        if (lst.size() != 1) {
            throw new IOException("not a StoreDir: " + lst);
        }
        return ((File) lst.get(0)).getName();
    }
    
    //--
    
    private final File dir;
    private final String url;
    private final String store;
    
    public StoreDir(File dir, String url, String store) {
        this.dir = dir;
        this.url = url;
        this.store = store;
    }
    
    public void load() throws IOException, TException, XException {
        run(metadataDir(), XGlobals.META_COLLECTION, true);
        run(contentDir(), store, true);
        System.out.println("done");
    }
    
    public void save() throws IOException, TException, XException {
        if (dir.exists()) {
            Files.delete(dir);
            System.out.println("directory " + dir + " deleted");
        }
        Files.mkdir(dir);
        run(metadataDir(), XGlobals.META_COLLECTION, false);
        run(contentDir(), store, false);
        System.out.println("done");
    }
    
    private void run(File dir, String collection, boolean load) throws IOException, TException, XException {
        Collection c;
        
        c = new Collection(url, collection);
        if (load) {
            System.out.println("loading " + url + "/" + collection);
            c.load(dir);
        } else {
            Files.mkdir(dir);
            System.out.println("saving " + url + "/" + collection);
            c.save(dir);
        }
    }

    private File contentDir() {
        return new File(dir, store);
    }

    private static final String METADATA = "metadata";

    private File metadataDir() {
        return new File(dir, METADATA);
    }
}

