/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/HelpSecurity.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.slide.store.tamino.tools.Command;
import org.apache.slide.store.tamino.tools.Output;
import org.apache.slide.util.cli.Abort;

public class HelpSecurity extends Command {
    private final String type;
    private final File catalinaHome;
    private final PrintStream out;
    
    public HelpSecurity(String name, Output out, String type, File catalinaHome) {
        super(name, out);
        this.catalinaHome = catalinaHome;
        this.type = type;
        this.out = out.quiet;
    }
    
    public void run() throws Abort {
        if (type == null) {
            overview();
        } else {
            type();
        }
    }
    
    private void overview() throws Abort {
        Iterator iter;
        
        out.println("Tamino WebDAV server provides various security types: ");
        try {
            iter = UrmTemplate.listTypes(catalinaHome).iterator();
        } catch (IOException e) {
            throw new Abort("error listing security types", e);
        }
        while (iter.hasNext()) {
            out.println("    " + iter.next());
        }
        out.println("Use");
        out.println("    inodavconfig helpsecurity <type>");
        out.println("to list options for the specified security type.");
        out.println("Use");
        out.println("    inodavconfig install security");
        out.println("         -administrator <admin> -password <passwd>");
        out.println("         -type <type> <type-specific options>");
        out.println("to enable security of the specified type.");
        caution();
    }
    
    private void type() throws Abort {
        out.println("Options for security type '" + type + "':");
        out.println(UrmTemplate.create(catalinaHome, type).getHelp());
        caution();
    }
    
    private void caution() {
        out.println();
        out.println("CAUTION: arguments with special character (especially , or =)");
        out.println("have to be quoted, e.g. \"cn=users,dc=localhost\".");
    }
}

