/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/HttpdConf.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.util.Files;

/**
 ** Modifies LoadModule lines in Httpd.conf files.
 **
 ** @version $Revision: 1.1 $
 **/
public class HttpdConf {
    private static final String WEBDAV_COMMENT = "Tamino WebDAV Server: out-of-process";
    private static final String BEGIN_WEBDAV_COMMENT = "## BEGIN " + WEBDAV_COMMENT;
    private static final String END_WEBDAV_COMMENT = "## END " + WEBDAV_COMMENT;
    private static final String BEGIN_CONFIG_LINE = "LoadModule jk2_module ";
    
    //--

    /** to be modified **/
    private final File file;

    /** module line we're interested in **/
    private final String moduleLine;
    
    public HttpdConf(File httpdConf, File module) {
        this.file = httpdConf;
        this.moduleLine = BEGIN_CONFIG_LINE + " \"" + module + "\"";
    }
    
    //--
    
    public File getFile() {
        return file;
    }
    
    /**
     * Adds the module, possibly overwriting existing modules.
     */
    public boolean add() throws IOException {
        List lines;
        boolean result;
        
        lines = read();
        result = strip(lines);
        lines.add(BEGIN_WEBDAV_COMMENT);
        lines.add(moduleLine);
        lines.add(END_WEBDAV_COMMENT);
        write(lines);
        return result;
    }
    
    /**
     * Removes the entry (comment and "include..") from Apache conf file.
     */
    public void remove() throws IOException {
        List lines;
        
        lines = read();
        strip(lines);
        write(lines);
    }
    
    /**
     * Returns true the module is configured
     */
    public boolean checkConfig() throws IOException {
        return strip(read());
    }
 
    //--
    
    private List read() throws IOException {
        return Files.readLines(file);
    }
    
    private void write(List lines) throws IOException {
        Files.writeLines(file, lines);
    }
    
    private boolean strip(List lines) throws IOException {
        Iterator src;
        String line;
        boolean modified;
        
        src = lines.iterator();
        modified = false;
        while (src.hasNext()) {
            line = (String) src.next();
            if (isSagComment(line) || isSagConfig(line)) {
                modified = true;
                src.remove();
            }
        }
        return modified;
    }
    
    private boolean isSagConfig(String line) {
        return line.startsWith(BEGIN_CONFIG_LINE);
    }
    
    private boolean isSagComment(String line) {
        return line.equals(BEGIN_WEBDAV_COMMENT) || line.equals(END_WEBDAV_COMMENT);
    }
}
