/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/InstallSecurity.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.slide.store.tamino.tools.Command;
import org.apache.slide.store.tamino.tools.Output;
import org.apache.slide.store.tamino.tools.stores.ActionDeclaration;
import org.apache.slide.store.tamino.tools.stores.XDomainFileHandler;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclAdministrator;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInit;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;
import org.apache.slide.util.cli.Abort;

public class InstallSecurity extends Command {
    private final SlideProperties slideProperties;
    private final String namespace;
    private final String type;
    private final File catalinaHome;
    private final List additionals;
    private final String admin;
    private final String passwd;
    private final String domain;
    
    public InstallSecurity(Output out,
                   String namespace, String type, File catalinaHome, List additionals,
                   String admin, String passwd, String domain)
    {
        super("install security", out);
        this.slideProperties = new SlideProperties();
        this.namespace = namespace;
        this.type = type;
        this.catalinaHome = catalinaHome;
        this.additionals = additionals;
        this.admin = admin;
        this.passwd = passwd;
        this.domain = domain;
    }
    
    public void run() throws Abort, XException, IOException {
        WebXml webXml;
        File urmConfig;
        UrmTemplate template;
        
        template = UrmTemplate.create(catalinaHome, type);
        urmConfig = template.getDest();
        try {
            template.apply(additionals);
        } catch (IOException e) {
            throw new Abort("error writing " + urmConfig, e);
        }
        out.verbose.println("urm configuration: " + urmConfig);
        Security.setPath(urmConfig);
        installUrm();
        webXml = new WebXml();
        webXml.addSecurity();
        slideProperties.enableSecurity();
    }
    
    private void installUrm() throws Abort, IOException {
        URMPrincipal principal;
        
        try {
            URMInit.init(false, admin, domain);
            principal = Security.getPrincipal(admin, passwd, domain);
            ActionDeclaration.defineAllUrm(principal);
            installRootAcl(principal);
        } catch (URMException e) {
            throw new Abort("urm initialization failed", e);
        }
    }
    
    private void installRootAcl(URMPrincipal principal) throws Abort {
        final String ROOT = "/";
        URMAclAdministrator aclAdmin;
        URMAcl acl;
        URMSubject subject;
        URMAdministrator admin;
        
        try {
            aclAdmin = principal.getURMAclAdministrator();
            admin = principal.getURMAdministrator();
            acl = aclAdmin.getAcl(ROOT);
            if (acl == null) {
                subject = admin.getUser(principal.getName(), principal.getDomain());
                aclAdmin.createAcl(ROOT, subject, true /* always inheritable */);
                acl = aclAdmin.getAcl(ROOT);
                if (acl == null) {
                    throw new XAssertionFailed();
                }
                acl.defineAce(URMConstants.GRANT, admin.getALLSubject(),
                              aclAdmin.getAction(URMConstants.URM_ALL_ACTION), 0, false);
            } else {
                // do nothing - acl already defined
            }
        } catch (URMException e) {
            throw new Abort(e);
        }
    }
}

