/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/Security.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.slide.store.tamino.tools.stores.XDomainFileHandler;
import org.apache.slide.store.tamino.tools.stores.XStoreGroupTypeList;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;
import org.apache.slide.util.XException;
import org.apache.slide.util.cli.Abort;
import org.xml.sax.SAXException;

/**
 * SecurityConfigurator.java
 *
 * @author eckehard.hermann@softareag.com
 */
public class Security {
    public static void setPath(File urmConfig) {
        System.setProperty(URMConfiguratorXML.DEFAULT_CONFIG_FILE_PATH, urmConfig.getPath());
    }
    
    public static URMPrincipal getPrincipal(String admin, String passwd, String domain)
        throws Abort, IOException
    {
        URMConfigurator conf;
        URMAuthenticator authenticator;
        URMPrincipal principal;
        
        try {
            conf = URMConfiguratorXML.newConfigfileConfigurator();
            conf = (URMConfigurator) conf.getSubConfigurators().get("Authenticator");
            authenticator = URMAuthenticator.newInstance(conf);
            principal = authenticator.authenticateUser(admin, passwd.toCharArray(), domain);
            principal.setActiveRole(URMConstants.URM_ADMIN_ROLE);
            return principal;
        } catch (SAXException e) {
            throw new Abort(e);
        } catch (ParserConfigurationException e) {
            throw new Abort(e);
        } catch (URMException e) {
            throw new Abort(e);
        }
    }
    
    public static void remove(String namespace) throws XException {
        WebXml webXml;
        SlideProperties slideProperties;
        
        webXml = new WebXml();
        webXml.removeSecurity();
        slideProperties = new SlideProperties();
        slideProperties.disableSecurity();
    }
    
    public static XStoreGroupTypeList groupTypes(XDomainFileHandler dfh) {
        return dfh.getDomain().getConfig().createTypes();
    }
}

