/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/Service.java,v 1.2 2004/09/27 15:48:18 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/09/27 15:48:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.IOException;
import org.apache.slide.store.tamino.tools.Env;
import org.apache.slide.util.Files;
import org.apache.slide.util.Strings;
import org.apache.slide.util.cli.Abort;
import org.apache.slide.util.os.Catalina;
import org.apache.slide.util.os.Net;
import org.apache.slide.util.os.Platform;

public class Service {
    private final Net service;
    
    public Service() {
        service = new Net("Tamino WebDAV Server");
    }
    
    private static String[] dirs = { "bin\\hotspot", "bin\\server", "bin\\classic", "bin\\client" };
    private static String[] prefixes = { "", "jre\\" };
    
    private File locateDll() throws Abort {
        int i;
        int j;
        File file;
        
        for (i = 0; i < dirs.length; i++) {
            for (j = 0; j < prefixes.length; j++) {
                file = new File(Platform.JAVA_HOME + "\\" + prefixes[j] + dirs[i] + "\\jvm.dll");
                if (file.exists()) {
                    return file;
                }
            }
        }
        throw new Abort("Missing Java Virtual Maschine to start service (jvm.dll)");
    }
    
    public void install(Catalina catalina) throws Abort, IOException {
        String[] args;
        File jvmDll = locateDll();
        
        args = Strings.append(
            new String[] {
                "-install",
                    service.getDescription(),
                    jvmDll.getPath()
            },
            catalina.opts
        );
        args = Strings.append(
            args,
            new String[] {
                "-Djava.class.path=" + Files.join(catalina.home, "bin", "bootstrap.jar")
                    + ";" + Files.join(Platform.JDK_HOME, "lib", "tools.jar"),
                "-Djava.protocol.handler.pkgs=com.softwareag.Tamino.db.protocols",
                "-Dcatalina.home=" + catalina.home,
                "-Dwebapp.home=" + Env.get().home,
                "-Dwebapp.context=" + catalina.getContext(),
                "-start",
                "org.apache.catalina.startup.Bootstrap",
                "-params",
                "start",
                "-stop",
                "org.apache.catalina.startup.Bootstrap",
                "-params",
                "stop",
                "-out",
                catalina.home + "\\logs\\nt_service_jvm_stdout.log",
                "-path",
                catalina.home + "\\native\\lib"
            }
        );
        catalina.service(args);
    }
    
    public void remove(Catalina catalina) throws Abort, IOException {
        catalina.service(new String[] { "-uninstall", service.getDescription() });
    }
    
    public void start() throws Abort, IOException {
        service.start();
    }
    
    public void stop() throws Abort, IOException {
        service.stop();
    }
}

