/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/SlideProperties.java,v 1.3 2004/07/30 06:52:04 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.slide.store.tamino.tools.Env;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.Files;
import org.apache.slide.util.XException;

/**
 ** Utility to handle security specific cproperty settings in slide.properties and java.security
 ** file
 **
 ** @author    eckehard.hermann@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class SlideProperties {
    /**
     ** activate org.apache.slide.security property in slide.properties
     **
     ** @pre        true
     ** @post       true
     **
     ** @exception  XException
     **/
    public void enableSecurity() throws XException {
        configSecurity("true");
    }
    
    /**
     ** remove org.apache.slide.security property in slide.properties
     **
     ** @pre        true
     ** @post       true
     **
     ** @exception  XException
     **/
    public void disableSecurity() throws XException {
        configSecurity("false");
    }
    
    //--
    
    private void configSecurity(String value) throws XException {
        Properties slideProperties;
        
        try {
            slideProperties = load();
            slideProperties.setProperty(Configuration.Property.IntegratedSecurity, value);
            save(slideProperties);
        } catch (IOException e) {
            throw new XException("slide.properties configuration failed", e);
        }
    }
    
    private Properties load() throws IOException {
        Properties slideProperties;
        FileInputStream is;
        
        slideProperties = new Properties();
        is = new FileInputStream(file());
        slideProperties.load(is);
        is.close();
        return slideProperties;
    }
    
    private void save(Properties slideProperties) throws IOException {
        FileOutputStream os;
        
        os = new FileOutputStream(file());
        slideProperties.store(os, null);
        os.close();
    }
    
    private File file() {
        return Files.file(Env.get().home + "/WEB-INF/classes/slide.properties");
    }
}

