/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/config/Variable.java,v 1.1 2004/03/25 16:18:04 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:04 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.config;

import org.apache.slide.util.Strings;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.cli.Abort;
import org.apache.slide.util.cli.Actuals;
import org.apache.slide.util.os.Platform;
import org.jdom.Attribute;
import org.jdom.Element;

public class Variable {
    //-- attribute name
    
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String DESC = "description";
    
    public static Variable create(Element e) {
        Variable v;
        
        if (!patchName(e)) {
            return null;
        }
        v = new Variable(e);
        if (v.getDescription() == null) {
            throw new XAssertionFailed("invalid template: no description for attribute " + v.getName());
        }
        return v;
    }
    
    private static boolean patchName(Element e) {
        Attribute attr;
        String name;
        
        attr = e.getAttribute(NAME);
        if (attr == null) {
            return false;
        }
        name = attr.getValue();
        if (!name.startsWith("${")) {
            return false;
        }
        if (!name.endsWith("}")) {
            throw new XAssertionFailed("invalid variable in template file: " + name);
        }
        name = name.substring(2, name.length() - 1);
        attr.setValue(name);
        return true;
    }
    
    //--
    
    private final Element element;
    
    public Variable(Element element) {
        this.element = element;
    }
    
    public String getName() {
        return element.getAttributeValue(NAME);
    }
    public String getDescription() {
        return element.getAttributeValue(DESC);
    }
    public String getValue() {
        return element.getAttributeValue(VALUE);
    }
    
    public void set(Actuals actuals) throws Abort {
        String value;
        String name;
        
        name = getName();
        value = actuals.getString(name, null);
        if (value == null) {
            value = getValue();
            if (value == null) {
                throw new Abort("mandatory parameter missing: " + name);
            }
        } else {
            actuals.remove(name);
        }
        element.setAttribute(VALUE, value);
    }
    
    
    public String getHelp() {
        return Strings.block(fill("  " + "-" + getName() + " <value>"), fill(""),
                             getDescription() + " " + getValueHelp(), 50,
                             Platform.CURRENT.lineSeparator, Platform.CURRENT.lineSeparator);
    }

    public String getValueHelp() {
        String v;
        
        v = getValue();
        if (v == null) {
            return "Mandatory option. ";
        } else {
            return "Optional, default is '" + v + "'.";
        }
    }
    
    private static String fill(String value) {
        return Strings.rfill(' ', 30, value);
    }
}

