/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/nixe/configure/NixeAdmin.java,v 1.3 2004/07/30 06:52:05 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:05 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.nixe.configure;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import org.jdom.Document;

/**
 * Interface to administrate Nixe (Non XML Indexer)
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class NixeAdmin {

    private TConnection tCon;

    public NixeAdmin (TConnection tCon) {
        this.tCon = tCon;
    }

    public NixeAdmin (String dbUri) {
        throw new UnsupportedOperationException ();
    }


    /**
     * Checks, if nixe is installed on the DB tCon points to.
     *
     * @return   a boolean
     *
     */
    public boolean isNixeInstalled () throws NixeConfigException {

        boolean result;

        try {
            TAccessLocation location = TAccessLocation.newInstance ("ino:SXS-ADMINISTRATION");
            TXMLObjectModel objectModel = TJDOMObjectModel.getInstance();

            TXMLObjectAccessor objAccessor =
                tCon.newXMLObjectAccessor (location, objectModel);

            TQuery query = TQuery.newInstance ("/ino:Repository/ino:Object[@Name='SXSBlobIndexer']");
            TResponse response = objAccessor.query (query);

            if (!response.getReturnValue().equals("0"))
                throw new NixeConfigException
                    ("Check for NixeInstalled failed: " + response.getReturnValue());

            if (response.hasFirstXMLObject())
                result = true;
            else
                result = false;


        } catch (TException e) {
            throw new NixeConfigException (e);
        }

        return result;
    }


    /**
     * defines the necessary schemas in collection
     *
     * @param    collection          a  String
     * @param    schema              a  String
     *
     */
    public void defineSchemas (String collection, String schema) {
        throw new UnsupportedOperationException ();
    }

    /**
     * removes nixe schemas
     *
     * @param    collection          a  String
     * @param    schema              a  String
     *
     */
    public void removeSchemas (String collection, String schema) {
        throw new UnsupportedOperationException ();
    }


    /**
     * returns the namespace schema names (dc, meta, office)
     *
     * @return   a String[]
     *
     */
    public String [] getNamespaceSchemaNames () {
        return NixeSchemaTemplate.namespaceSchemas;
    }

    /**
     * Returns all necessary schemas as documents. The caller may now define the
     * schema himself (XDav)
     *
     * @param    collection          a  String
     * @param    schema              a  String
     *
     * @return   a Document[]
     *
     * @throws   NixeConfigException
     *
     */
    public Document[] getNixeSchemasAsDocuments (String collection, String schema)
        throws NixeConfigException {
        return new NixeSchemaTemplate().getNixeSchemasAsDocuments (collection, schema);
    }

}

