/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/nixe/configure/NixeSchemaTemplate.java,v 1.3 2004/07/30 06:52:05 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:05 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.nixe.configure;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * SchemaConfig creates and removes the Nixe schemas. Don't use any dependencies
 * to xDav!
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class NixeSchemaTemplate  {

    // order matters!
    static final String [] namespaceSchemas = new String []
    {"office", "meta", "dc"};

    // order matters!
    static final String [] templates = new String []
    {"dc", "meta", "office", "template"};

    /**
     * Method createDoc
     *
     * @param    schemaString        a  String
     *
     * @return   a Document
     *
     * @throws   JDOMException
     *
     */
    private Document createDoc (String schemaString) throws JDOMException, IOException {

        SAXBuilder builder = new SAXBuilder ();
        Reader rd = new StringReader (schemaString);

        return builder.build (rd);
    }

    /**
     * returns the specified template as String
     *
     * @param    templates           a  String
     *
     * @return   a String
     *
     */
    private String getTemplate (String templateName) throws NixeConfigException {

        int BUF_SIZE = 10 * 1024;

        byte [] buf = new byte [BUF_SIZE];

        templateName = templateName + ".tsd";

        URL url = this.getClass().getResource (templateName);
        if (url == null) throw new NixeConfigException (templateName + " not found");

        try {
            InputStream is = url.openStream();

            int bytesRead = 0;
            int i = 0;

            i = is.read (buf, bytesRead, BUF_SIZE - bytesRead);

            while (i != -1) {
                bytesRead += i;
                i = is.read (buf, bytesRead, BUF_SIZE - bytesRead);
            }

            return new String (buf, "UTF-8").trim();

        } catch (IOException e) {
            throw new NixeConfigException (e);
        }
    }


    /**
     * Method getNixeSchemasAsDocuments
     *
     * @param    collection          a  String
     * @param    schema              a  String
     *
     * @return   a Document[]
     *
     * @throws   NixeConfigException
     *
     */
    Document[] getNixeSchemasAsDocuments (String collection, String schema) throws NixeConfigException {

        Replacer replacer  = new Replacer ();
        replacer.add ("my_collection", collection);
        replacer.add ("my_schema",     schema);
        replacer.add ("my_doctype",    schema);

        Document [] result = new Document [templates.length];

        try {
            for (int i = 0; i < templates.length; i++) {
                String template = getTemplate (templates [i]);
                String schemaString = replacer.replace (template);
                Document schemaDoc = createDoc (schemaString);
                result [i] = schemaDoc;
            }
        }
        catch (JDOMException e) {
            throw new NixeConfigException (e);
        }
        catch (IOException e) {
            throw new NixeConfigException (e);
        }
        return result;
    }

}

