/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/nixe/configure/Replacer.java,v 1.3 2004/07/30 06:52:05 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:05 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.nixe.configure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


/**
 * replace strings. stolen form xdav.tools.launcher.Properties
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class Replacer {
    // not a Map -- ordering has to be preserved
    private final List keys;
    private final List values;

    public Replacer() {
        keys = new ArrayList();
        values = new ArrayList();
    }

    private static final String START = "${";
    private static final String END = "}";


    public void add(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (keys.contains(key)) {
            // first definition wins
            return;
        }
        keys.add(key);
        values.add(value);
    }


    public String replace (String template) {
        int start;
        int end;
        StringBuffer result;
        String subst;
        String name;
        int last;

        result = new StringBuffer();
        last = 0;
        while (true) {
            start = template.indexOf(START, last);
            if (start == -1) {
                break;
            }
            end = template.indexOf(END, start);
            if (end == -1) {
                throw new IllegalArgumentException("no end after ofs: " + start);
            }
            name = template.substring(start + START.length(), end);
            subst = getOptional(name);
            if (subst == null) {
                throw new IllegalArgumentException("no such property: " + name);
            }
            result.append(template.substring(last, start));
            result.append(subst);
            last = end + END.length();
        }
        result.append(template.substring(last));
        return result.toString();
    }


    private String getOptional(String key) {
        int idx;

        idx = indexOf(key);
        if (idx == -1) {
            return null;
        } else {
            return (String) values.get(idx);
        }
    }


    private int indexOf(String key) {
        return keys.indexOf(key);
    }
}
