/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/DocumentEnabler.java,v 1.1 2004/03/25 16:18:05 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:05 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import org.apache.slide.store.tamino.datastore.XContentId;
import org.apache.slide.store.tamino.datastore.XDescriptorsAccessor;
import org.apache.slide.store.tamino.jdomobjects.XDescriptors;
import org.apache.slide.store.tamino.jdomobjects.XDescriptorsUtil;
import org.apache.slide.store.tamino.jdomobjects.XFactory;
import org.apache.slide.store.tamino.tools.repairer.Patch;
import org.apache.slide.store.tamino.tools.repairer.RepairConstants;
import org.apache.slide.store.tamino.tools.repairer.XRepairLogWriter;
import org.apache.slide.store.tamino.tools.repairer.XTaminoClient;
import org.apache.slide.store.tamino.tools.repairer.enabler.Naming;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;

public class DocumentEnabler extends Patch {
    private final XContentId contentId;
    
    private final boolean useBinding;
    private final XUri rootUri;
    private final String rootUuri;
    private final Naming naming;
    
    public DocumentEnabler(boolean useBinding, XUri rootUri, String rootUuri, XContentId contentId, Naming naming)
        throws XException
    {
        this.useBinding = useBinding;
        this.rootUri = rootUri;
        this.rootUuri = rootUuri;
        this.contentId = contentId;
        this.naming = naming;
    }
    
    public void log(XRepairLogWriter logWriter) {
        logWriter.println(RepairConstants.TC_CHECK_DETAILS, RepairConstants.MSG_FOUND_NOT_ENABLED,
                          contentId.toString());
    }
    
    public void apply(XTaminoClient taminoClient) throws XException {
        String taminoCollection;
        XDescriptorsAccessor accessor;
        DocumentImpl document;
        XUri uri;
        int max;
        XDescriptors parent;
        XDescriptors child;
        int i;
        String childUuri;
        String segment;
        ObjectNode parentNode;
        XUri current;

        taminoCollection = taminoClient.getContentCollection();
        accessor = taminoClient.getDescriptorsAccessor();
        document = taminoClient.toDocument(contentId);
        uri = rootUri.append(new XUri(naming.getName(document)));
        max = uri.size();
        parent = accessor.readOneRwDescriptorsByUuri(rootUuri);
        for (i = rootUri.size(); i < max; i++) {
            parentNode = parent.getUuriObjectNode();
            segment = uri.segment(i);
            childUuri = parentNode.getBindingUuri(segment);
            if (childUuri == null) {
                current = uri.suburi(0, i + 1);
                if (i + 1 == max) {
                    child = XFactory.createMemberDescriptor(useBinding, taminoCollection, current,
                                                            document.getContentId().toString(), document.getLength(), document.getMimeType());
                } else {
                    child = XFactory.createCollectionDescriptor(useBinding, taminoCollection, current.toString());
                    childUuri = child.getUuri();
                }
                XDescriptorsUtil.addChildBinding(parent, child, segment);
                XDescriptorsUtil.addParentBinding(child, parent, segment);
                accessor.update(parent);
                accessor.insert(child);
            } else {
                child = accessor.readOneRwDescriptorsByUuri(childUuri);
                if (i + 1 < max) {
                    // do nothing - folder exists
                } else {
                    throw new XException("document already enabled: " + uri);
                }
            }
            parent = child;
        }
    }
}

