/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/DocumentImpl.java,v 1.2 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.slide.store.tamino.datastore.XContentId;
import org.apache.slide.store.tamino.tools.Env;
import org.apache.slide.store.tamino.tools.repairer.enabler.Document;

/** TODO: merge with XContentId **/
public class DocumentImpl implements Document {
    private final XContentId contentId;
    private final String mimeType;
    private final byte[] content;
    private final String inoDocname;
    
    public DocumentImpl(XContentId contentId, byte[] content, String mimeType, String inoDocname) {
        this.contentId = contentId;
        this.content = content;
        this.mimeType = mimeType;
        this.inoDocname = inoDocname;
    }

    //-- interface implementation
    
    public String getDoctype() {
        return contentId.getSchema();
    }
    
    public String getTaminoId() {
        return contentId.getId();
    }
    
    public InputStream getContent() {
        return new ByteArrayInputStream(content);
    }
    
    public String getMimeType() {
        return mimeType;
    }

    public List getMimeExtensions() {
        return Env.get().getMimeMapping().getExtensions(mimeType);
    }
    
    public String getTaminoDocname() {
        return inoDocname;
    }
    
    //-- additional services
    
    public long getLength() {
        return content.length;
    }

    public XContentId getContentId() {
        return contentId;
    }
}


