/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/MissingMetadataCheck.java,v 1.2 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import java.util.Iterator;
import org.apache.slide.store.tamino.datastore.XContentId;
import org.apache.slide.store.tamino.tools.repairer.DocumentEnabler;
import org.apache.slide.store.tamino.tools.repairer.enabler.Naming;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;

public class MissingMetadataCheck extends AbstractCheck implements RepairConstants {
    private final XUri rootUri;
    
    /** the root node where to create the missing metadocs */
    private final String rootUuri;

    private final Naming naming;
    
    protected MissingMetadataCheck( XTaminoClient taminoClient, XUri rootUri, String rootUuri, Naming naming)
        throws XException
    {
        super(taminoClient, MSG_START_MISSING_METADATA, MSG_DESCR_MISSING_METADATA);
        this.rootUri = rootUri;
        this.rootUuri = rootUuri;
        this.naming = naming;
    }
    
    /**
     * This method finds all stored documents without metadata information.
     *
     */
    public void check() throws XException {
        Iterator iter;
        XContentId id;
        
        iter = taminoClient.getNotWebDAVenabledDocuments().iterator();
        while (iter.hasNext()) {
            id = (XContentId) iter.next();
            logAndApplyPatch(new DocumentEnabler(RepairHandler.useBinding(rootUri.toString()), rootUri, rootUuri, id, naming));
        }
    }
}
