/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/OnOpenTaToken.java,v 1.1 2004/03/25 16:18:05 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:05 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.util.XAssertionFailed;


/**
 * On-open-transaction token. Controls the lockStore() method in the case
 * of open transactions
 */
public class OnOpenTaToken {
    public static final OnOpenTaToken DEFAULT =
        new OnOpenTaToken( XGlobals.ON_OPEN_TA_WAIT, XGlobals.ON_OPEN_TA_WAIT_TIMEOUT );
    
    
    final int action;
    final long waitTimeout;
    
    public OnOpenTaToken( int action, long waitTimeout ) {
        this.action = action;
        this.waitTimeout = waitTimeout;
    }
    
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append( "action=" ).append( action ).append( "(" );
        switch (action) {
            case XGlobals.ON_OPEN_TA_ERROR:
                b.append( "error" );
                break;
            case XGlobals.ON_OPEN_TA_ROLLBACK:
                b.append( "rollback" );
                break;
            case XGlobals.ON_OPEN_TA_WAIT:
                b.append( "wait" );
                break;
            default:
                throw new XAssertionFailed("" + action);
        }
        b.append( ")" );
        if( action == XGlobals.ON_OPEN_TA_WAIT )
            b.append( " timeout=" ).append( waitTimeout );
        return b.toString();
    }
}

