/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/RepairConstants.java,v 1.2 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.repairer;

/**
 * Repairer messages
 *
 * @version $Revision: 1.2 $
 */
public interface RepairConstants {
    
    /** Messages */
    String MSG_CREATED_METADOC_TO_KEEP_CONTENTID = "Created new metadata document at URI {0} to keep reference to content ID {1}";
    String MSG_DESCR_CONTENT_INCONSISTENCIES = "Check for content inconsistencies";
    String MSG_DESCR_INVALID_DESCRIPTORS = "Check invalid descriptor documents";
    String MSG_DESCR_DIR_INCONSISTENCIES = "Check for namespace inconsistencies (dangling child references)";
    String MSG_DESCR_GARBAGE_CHECK = "Check for unreachable nodes";
    String MSG_DESCR_DUPLICATE_CONTENT_IDS = "Check for duplicate content IDs";
    String MSG_DESCR_DUPLICATE_DESCRIPTORS_IDS = "Check for duplicate descriptors IDs";
    String MSG_DESCR_METADATA_VERSION = "Check for metadata version";
    String MSG_DESCR_MISSING_METADATA = "Check for missing metadata (documents which are not WebDAV-enabled)";
    String MSG_DESCR_INVALID_CONTENTSCHEMA = "Check for defect content data TSD3 schemas which have been created automatically";
    String MSG_END_CHECK = "*** End of check process ***";
    String MSG_END_REPAIR = "*** End of repair process ***";
    String MSG_FOUND_CONTENTLENGTH_MISMATCH = "Found content length mismatch at URI {0} - real length: {1}, documented length: {2}";
    String MSG_FOUND_DUPLICATE_CONTENTID = "Found multiple metadata documents refering to the same content document - content ID: {0}, descriptor IDs: {1}";
    String MSG_FOUND_DUPLICATE_UURI = "Found duplicate metadata documents for UURI {0}";
    String MSG_FOUND_INVALID_REF = "Found invalid reference in UURI {0} to UURI {1}";
    String MSG_FOUND_NOT_ENABLED = "Found Tamino document without metadata document at content ID {0}";
    String MSG_FOUND_OUTDATED_METADATA_SCHEMA = "Found old schema version of metadata schema - schema version: {0}";
    String MSG_FOUND_OUTDATED_METADATA = "Found old schema version of metadata at URI {0} - schema version: {1}";
    String MSG_FOUND_OUTDATED_HISTORY_METADATA = "Found old schema version of history metadata at URI {0}";
    String MSG_FOUND_METADATA_WITHOUT_CONTENT = "Found metadata document at URI {0} - missing content documentat content ID: {1}";
    String MSG_FOUND_INVALID_METADATA = "Found invalid metadata document at UURI {0}.";
    String MSG_FOUND_UNREACHABLE_NODE = "Found namespace inconsistency at URI {0} - node is unreachable";
    String MSG_FOUND_BINDING_NAME_MISSMATCH = "Found binding name missmatch at URI {0}, segment {1}, referenced URI {2}, back-segment {3}";
    String MSG_FOUND_INVALID_CONTENTSCHEMA = "Found invalid content data schema {0}";
    String MSG_INCONS_FOUND = "bad metadata document(s) found";
    String MSG_INCONS_REPAIRED = "metadata document(s) repaired";
    String MSG_MS = "ms";
    String MSG_START_CHECK = "*** Start of check process ***";
    String MSG_START_CONTENT_INCONSISTENCIES = "Content inconsistency";
    String MSG_START_DIR_INCONSISTENCIES = "Namespace inconsistency";
    String MSG_START_GARBAGE_CHECK = "Garbage check";
    String MSG_START_DUPLICATE_CONTENT_IDS = "Duplicate content IDs";
    String MSG_START_DUPLICATE_DESCRIPTORS_IDS = "Duplicate descriptors IDs";
    String MSG_START_METADATA_VERSION = "Metadata version";
    String MSG_START_INVALID_DESCRIPTORS = "Invalid descriptors";
    String MSG_START_INVALID_CONTENTSCHEMA = "Invalid content schema";
    String MSG_START_MISSING_METADATA = "Missing metadata";
    String MSG_START_REPAIR = "*** Start of repair process ***";
    String MSG_SUCCESS = "Success";
    String MSG_UNABLE_TO_REPAIR = "Unable to repair";
    String MSG_WARNING_SKIPPED_MULTIDESC = "Warning: skipped multi-descriptors metadata document (history data) at URI {0}";
    
    
    
    /** Tokens */
    int TC_CONSOLE_ONLY      = 0;
    int TC_CHECK             = 1;
    int TC_TOTAL_TIME        = 2;
    int TC_TOTAL_COUNT       = 3;
    int TC_TOTAL_RESULT      = 4;
    int TC_ERROR             = 5;
    int TC_UNIT              = 6;
    int TC_CHECK_DESCRIPTION = 7;
    int TC_CHECK_TIME        = 8;
    int TC_CHECK_COUNT       = 9;
    int TC_CHECK_RESULT      = 10;
    int TC_CHECK_DETAILS     = 11;
    
    int TC_CONSOLE_MAX       = 6;    // tokens 0 to 5 are outputed to console
    int TC_CHECK_DETAILS_MAX = 1000; // max number of <detail> entries per check in log file
    
    // to show in console
    String[] TC_TOKEN_NAMES = new String[]{
        "",
        "Check",
        "Time",
        "Count",
        "Result",
        "Error",
        "Repair Unit",
        "Description",
        "Time",
        "Count",
        "Result",
        "Details"
    };
}


