/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/UniqueDescriptorsIdCheck.java,v 1.4 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.tools.repairer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.store.tamino.common.XDatastoreException;
import org.apache.slide.store.tamino.datastore.XPathFactory;
import org.apache.slide.store.tamino.jdomobjects.XDescriptors;
import org.apache.slide.store.tamino.jdomobjects.XUuri;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;

/**
 ** Test the uniqueness of uuri entries in the WebDAV meta data information.
 **
 ** @author    Hardy.Kiefer@softwareag.com
 ** @author    Peter.Nevermann@softwareag.com
 ** @version   $Revision: 1.4 $
 **/
public class UniqueDescriptorsIdCheck extends AbstractCheck implements RepairConstants {
    /**
     ** Creates a test to find not unique uuri's in meta data.
     **
     ** @pre        (taminoClient != null)
     **
     ** @param      taminoClient       the current database session
     **/
    protected UniqueDescriptorsIdCheck(XTaminoClient taminoClient) throws XException {
        super(taminoClient, MSG_START_DUPLICATE_DESCRIPTORS_IDS, MSG_DESCR_DUPLICATE_DESCRIPTORS_IDS);
    }
    
    
    /**
     * This method finds duplicate metadata uuris.
     */
    public void check() throws XException {
        Map allUuris = taminoClient.getDescriptorsAccessor().getUurisMap(XPathFactory.uuris( taminoCollection ));     // inoId -> uuri
        List uuriToKeep = new ArrayList();                            // uuris I've already seen descriptors for
    
        Iterator it = allUuris.entrySet().iterator();
        while( it.hasNext() ) {
            Map.Entry e = (Map.Entry)it.next();
            String inoId = (String)e.getKey();
            String uuri = (String)e.getValue();
            
            if( uuriToKeep.contains(uuri) ) {
                logAndApplyPatch(new Duplicate(taminoClient.getDescriptorsAccessor().readDescriptorsByUuri(inoId)));
            } else {
                uuriToKeep.add( uuri );
            }
        } // end-while
    }
    
    public static class Duplicate extends Patch {
        private final IDescriptors desc;
        
        public Duplicate(IDescriptors desc) {
            this.desc = desc;
        }
        
        public void apply(XTaminoClient taminoClient) throws XDatastoreException {
            String oldUuri;
            String newUuri;
            
            oldUuri = desc.getUuri();
            newUuri = XUuri.create(XUuri.isUuri(oldUuri), taminoClient.getContentCollection() + XUri.SEP + "Duplicate_Of_Uuri" + oldUuri);
            // TODO: newUuri is not necessarily unique if binding is switched off
            taminoClient.getDescriptorsAccessor().update((XDescriptors) desc.getClone(newUuri));
        }
        
        public void log(XRepairLogWriter logWriter) {
            logWriter.println(TC_CHECK_DETAILS, MSG_FOUND_DUPLICATE_UURI, new Object[]{ desc.getUuri() });
        }
    }
}




