/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/ValidDescriptorsCheck.java,v 1.2 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.tools.repairer;

import java.util.Iterator;
import java.util.Map;
import org.apache.slide.store.tamino.datastore.XPathFactory;
import org.apache.slide.store.tamino.jdomobjects.XDescriptors;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;

public class ValidDescriptorsCheck extends AbstractCheck implements RepairConstants {
    protected ValidDescriptorsCheck(XTaminoClient taminoClient) throws XException {
        super(taminoClient, MSG_START_INVALID_DESCRIPTORS, MSG_DESCR_INVALID_DESCRIPTORS);
    }
    
    public void check() throws XException {
        Map uuris;
        Iterator iter;
        Map.Entry e;
        String inoId;
        String uuri;
        XDescriptors desc;
        String msg;
        
        uuris = taminoClient.getDescriptorsAccessor().getUurisMap(XPathFactory.uuris( taminoCollection ));  // inoId -> uuri
        iter = uuris.entrySet().iterator();
        while( iter.hasNext() ) {
            e = (Map.Entry)iter.next();
            inoId = (String) e.getKey();
            uuri = (String)e.getValue();
            // do not read by uuri -- the uuri is not necesarily unique at this time
            desc = taminoClient.getDescriptorsAccessor().readDescriptorsByIno(inoId);
            try {
                desc.doValidate();
            } catch (XAssertionFailed notUsed) {
                msg = XRepairLogWriter.format(MSG_FOUND_INVALID_METADATA, new Object[] { uuri });
                // TODO: create missing metadata for content of this descriptor
                logAndApplyPatch(new ContentCheck.RemoveDescriptor(inoId, msg));
            }
        }
    }
}


